import * as React from 'react';
import { Link } from 'react-router';

import { SubSection } from 'common/constants';

const styles = require('./styles.scss');

export interface SubNavProps {
  location: any;
  urlHelper: (section: SubSection, model?: any) => string;
  sections: SubSection[];
  model?: any;
}

export class SubNavComponent extends React.Component<any, any> {

  public render() {
    const { urlHelper, sections, model } = this.props;
    let navItems = sections.map((section: SubSection) => {
      let classes = ['section-option', section.enabled ? 'enabled' : 'disabled'];
      const url = model
        ? urlHelper(section, model)
        : urlHelper(section);
      if ( this.props.location.pathname === url && section.enabled ) {
        classes.push('selected');
      }
      const content: JSX.Element = section.enabled
        ? <Link to={url}>{section.title}</Link>
        : <span>{section.title}</span>;

      return (
        <li key={section.title} className={classes.join(' ')}>
          {content}
        </li>
      );
    });

    return (
      <div className="sub-section-nav nav-container">
        <ul className="nav-contents">
          {navItems}
        </ul>
      </div>
    );
  }
}
