import * as React from 'react';
import { Link } from 'react-router';
import { TeamModel } from 'tourney-sdk-react';

import { Placeholder } from 'ui/components/placeholder';
import { TeamLogo } from 'ui/components/team/logo';
import { Tournament } from 'common/constants';
import { AppModel } from 'state/model';

const styles = require('./styles.scss');

export class TeamButtonComponent extends React.Component<any, any> {

  public render() {
    let { team } = this.props;
    return (
      <div className="team-button">
        <TeamLogo team={team}/><span className="team-title">{team.name}</span>
      </div>
    );
  }
}
