import * as React from 'react';
import { Link } from 'react-router';

import { Tournament, CHARITIES, CharityInfo, ICONS } from 'common/constants';
import { AppModel } from 'state/model';
import { Tooltip } from 'ui/components/tooltip';
import { Button } from 'ui/components/button';

const styles = require('./styles.scss');

export class TeamCreateComponent extends React.Component<any, any> {
  public teamNameInput: any;
  public componentWillMount() {
    this.state = {
      creating: false,
      teamName: '',
      charity: undefined,
      error: undefined,
    };
  }

  public render() {
    let contents = this.state.creating ? this.renderCreateTeamName() : this.renderCreateTeam();

    return (
      <div className="create-team-component">
        {contents}
      </div>
    );
  }

  // This layout can be rendered with:
  //    locked => unlocked
  // Render team component when unable to create team
  public renderCreateTeam(): JSX.Element {
    // This will be run by overall user state
    const locked: Boolean = !this.props.user.is_verified;
    const classes: string[] = ['create-team'];
    classes.push(locked ? 'locked' : 'unlocked');

    const handleClick = () => {
      if (!locked) {
        this.setState({ creating: true });
      }
    };

    return (
      <div className={classes.join(' ')} onClick={handleClick}>
        <img className="create-group-icon" src={ICONS.createteam} />
        <span className="create-text">
          Create a Team
        </span>
      </div>
    );
  }

  public createTeam() {
    if (this.state.teamName === '' || this.state.charity === undefined || this.state.charity === '') {
      this.setState({ error: 'Both team name and charity are required fields.' });
      return;
    }
    this.props.createTeam({
      name: this.state.teamName,
      settings: {
        charity: this.state.charity
      }
    }).then((json: any) => {
      this.setState({
        creating: false,
        teamName: '',
        charity: undefined,
      });
    }).catch((err: any) => {
      this.setState({
        error: err.data.error
      });
    });
  }

  public renderCreateTeamName(): JSX.Element {
    const handleTeamName = (event: any) => {
      this.setState({ teamName: event.target.value, error: undefined });
    };

    let tooltip;
    if (this.state.error) {
      tooltip = <Tooltip position="top">{this.state.error}</Tooltip>;
    }

    const charityOptions = CHARITIES.map((charity: CharityInfo) => <option value={charity.name} key={charity.name}>{charity.name}</option>);
    return (
      <div className="create-team create">
        <input
          autoFocus
          type="text"
          className="create-team-name"
          placeholder="Team Name"
          value={this.state.teamName}
          onChange={handleTeamName}
          autoComplete="off"
          autoCorrect="off"
          autoCapitalize="off"
          spellCheck={false}
          />
        <select className="create-team-charity" defaultValue="" value={this.state.charity} onChange={this.updateCharity.bind(this)}>
          <option value="" disabled>Select your charity</option>
          {charityOptions}
        </select>
        <div className="create-button-container">
          {tooltip}
          <Button primary onClick={this.createTeam.bind(this)}> 
            Create
          </Button>
        </div> 
      </div>
     );
  }

  private updateCharity(event: any) {
    this.setState({ charity: event.target.value, error: undefined });
  }
}
