import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import { createTeam } from 'tourney-sdk-react';

import { AppModel } from 'state/model';

import { TeamCreateComponent } from './component';

function mapStateToProps(state: AppModel): any {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? state.tourney.users[current] : undefined;

  return {
    loggedIn,
    user
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>) {
  return bindActionCreators({ createTeam }, dispatch);
}

export const TeamCreate = connect(mapStateToProps, mapDispatchToProps)(TeamCreateComponent);
