import * as React from 'react';
import { Link } from 'react-router';

import { ICONS } from 'common/constants';
import { AppModel } from 'state/model';
import { Button } from 'ui/components/button';
import { Tooltip } from 'ui/components/tooltip';

const styles = require('./styles.scss');

const BUTTON_STATUS = {
  UNSET: '',
  ERROR: 'error',
  LOADING: 'loading'
};

export class TeamInviteComponent extends React.Component<any, any> {
  public emailInput: any;
  private errorTimeout: any;
  constructor() {
    super();

    this.state = {
      status: BUTTON_STATUS.UNSET,
      email: '',
      error: undefined,
    };
  }

  public createTeamInvitation() {
    clearTimeout(this.errorTimeout);
    this.errorTimeout = undefined;
    this.setState({ status: BUTTON_STATUS.LOADING });
    this.props.createTeamInvitation({
      team_id: this.props.teamId,
      email: this.state.email
    })
    .then((response: any) => {
      this.setState({ status: BUTTON_STATUS.UNSET, email: '' });
    })
    .catch((e: any) => {
      this.setState({ status: BUTTON_STATUS.ERROR, error: e.data.error });
      this.clearError();
    });
  }

  public handleChange(event: any): any {
    return this.setState({ status: BUTTON_STATUS.UNSET, email: event.target.value, error: undefined });
  }

  public handleKeyPress(event: any) {
    if (event.key === 'Enter') {
      this.createTeamInvitation();
    }
  }

  public render() {
    const buttonProps = {
      loading: this.state.status === BUTTON_STATUS.LOADING,
      error: this.state.status === BUTTON_STATUS.ERROR,
      onClick: this.createTeamInvitation.bind(this),
      primary: true,
    };

    let tooltip;
    if (this.state.error) {
      tooltip = <Tooltip position="top-right">{this.state.error}</Tooltip>;
    }
    return <div className="player-invitation">
      <input
        autoFocus
        type="text"
        autoComplete="off"
        autoCorrect="off"
        autoCapitalize="off"
        spellCheck={false}
        placeholder="Email"
        value={this.state.email}
        onChange={this.handleChange.bind(this)}
        onKeyPress={this.handleKeyPress.bind(this)}
      />
      <div className="email-button-container">
        {tooltip}
        <Button {...buttonProps}>
          <img src={ICONS.addbuddy} />
        </Button>
      </div>
    </div>;
  }

  private clearError(delay = 10) {
    this.errorTimeout = setTimeout(() => {
      this.setState({
        status: BUTTON_STATUS.UNSET,
        error: undefined
      });
    }, delay * 1000);
  }
}
