import * as React from 'react';
import { Link } from 'react-router';
import { TeamModel, TournamentModel } from 'tourney-sdk-react';

import { urlToTournamentSection } from 'common/helpers';
import { TOURNAMENT_SUB_SECTIONS_MAP } from 'common/constants';
import { TeamLogo } from 'ui/components/team/logo';

const styles = require('./styles.scss');

export interface TeamLogoListProps {
  tournament: TournamentModel;
  limit?: number;
}

export class TeamLogoListComponent extends React.Component<TeamLogoListProps, any> {

  public render() {
    const { tournament } = this.props;
    const teams = tournament.teams;
    const limit = this.props.limit || 6;
    const teamLogos = teams.slice(0, limit).map((team: TeamModel) => <TeamLogo key={team.id} team={team}/>);
    let showMore = (teams.length > limit) ? this.renderMoreButton(teams.length - limit) : null;
    return (
      <section className="team-logo-list">
        {teamLogos}
        {showMore}
      </section>
    );
  }

  private renderMoreButton(additionalTeams: number) {
    const urlToTeamSection = urlToTournamentSection(TOURNAMENT_SUB_SECTIONS_MAP.TEAMS, this.props.tournament);
    return (
      <Link to={urlToTeamSection}>
        <div className="all-teams-link">
          {additionalTeams} <i className="fa fa-angle-right" />
        </div>
      </Link>
    );
  }
}
