import * as React from 'react';
import { Link } from 'react-router';
import { TeamModel } from 'tourney-sdk-react';

import { ICONS } from 'common/constants';
import { Image } from 'ui/components/image';
import { Placeholder } from 'ui/components/placeholder';

const styles = require('./styles.scss');

export interface TeamLogoProps {
  team: TeamModel;
}

export class TeamLogo extends React.Component<TeamLogoProps, any> {

  public render() {
    const defaultTeam = require('../../../../common/assets/def_team.png') as string;
    const { team } = this.props;
    const thumbLogo = team.logo.thumb
      ? <Image src={team.logo.thumb} />
      : <Image src={defaultTeam} />;
    return (
      <div className="team-logo">
        {thumbLogo}
      </div>
    );
  }
 }
