import * as _ from 'lodash';
import * as React from 'react';
import { connect } from 'react-redux';
import { denormalize, schema } from 'normalizr';
import { bindActionCreators, Dispatch } from 'redux';
import {
  TeamSchema,
  TeamInvitationModel,
  updateTeam,
  deleteTeamInvitation,
  deleteTeamUser,
  getTeam,
  deleteTournamentEntry,
  UserSchema
} from 'tourney-sdk-react';

import { AppModel } from 'state/model';

import { TeamManageComponent } from './component';

function mapStateToProps(state: AppModel, ownProps: AppModel): {} {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const myUser = loggedIn ? denormalize(current, UserSchema, state.tourney) : undefined;

  return {
    myUser
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>): any {
  return bindActionCreators({
    updateTeam,
    deleteTeamUser,
    deleteTeamInvitation,
    getTeam,
    deleteTournamentEntry
  }, dispatch);
}

export const TeamManage = connect(mapStateToProps, mapDispatchToProps)(TeamManageComponent) as React.ComponentClass<any>;
