import * as React from 'react';
import { Link } from 'react-router';
import { TeamModel } from 'tourney-sdk-react';

import { Placeholder } from 'ui/components/placeholder';
import { TeamLogo } from 'ui/components/team/logo';
import { Tournament } from 'common/constants';
import { AppModel } from 'state/model';

const styles = require('./styles.scss');

// TODO:
// This should probably be passed the tournament-entry or some type of model
// that contains the teams current performance in a tournament

export interface TeamStandingProps {
  team: TeamModel;
  showSpoilers?: boolean;
  position?: number;
  points?: number;
}

export class TeamStandingComponent extends React.Component<TeamStandingProps, any> {
  public render() {
    // const randomArrowDirection = Math.random() >= 0.5 ? 'fa-angle-up' : 'fa-angle-down';

    const { team, showSpoilers } = this.props;
    const index = this.props.position || 0;

    let classes = ['team-standing', showSpoilers ? '' : 'hide-spoilers'];

    return (
      <article className={classes.join(' ')} key={team.id}>
        {/*<div className="position"><Placeholder string={index + 1}/></div>*/}
        <div className="arrow-direction">
          {/*<i className={['fa', randomArrowDirection].join(' ')}/>*/}
        </div>
        <TeamLogo team={team} />
        <div className="team-name">
          {team.name}
        </div>
        <div className="team-points">
          <Placeholder>0-0</Placeholder>
        </div>
      </article>
    );
  }
}

TeamStandingComponent.propTypes = {
  team: React.PropTypes.object.isRequired
};
