import * as React from 'react';
import { Link } from 'react-router';
import { TeamModel, TournamentModel } from 'tourney-sdk-react';

import { TeamStanding } from '../standing';

import { TOURNAMENT_SUB_SECTIONS_MAP } from 'common/constants';
import { urlToTournamentSection } from 'common/helpers';

const styles = require('./styles.scss');

interface TeamStandingsProps {
  tournament: TournamentModel;
  limit?: number;
  showSpoilers?: boolean;
  showMore?: boolean;
}

export class TeamStandingsComponent extends React.Component<TeamStandingsProps, any> {
  public render() {
    const { tournament } = this.props;
    const limit = this.props.limit || 5;
    const showSpoilers = !!this.props.showSpoilers;
    const standings = tournament.teams.slice(0, limit).map(
      (team: TeamModel, idx: number) => <TeamStanding team={team} showSpoilers={showSpoilers} key={idx}/>
    );

    let display = undefined;
    if (tournament.tournament_entries.length > limit && this.props.showMore) {
      const additionalTeams = tournament.tournament_entries.length - limit;
      display = (
        <div className="more-teams">
          <Link to={urlToTournamentSection(TOURNAMENT_SUB_SECTIONS_MAP.TEAMS, tournament)}>
            And {additionalTeams} more...
          </Link>
        </div>
      );
    }

    return <div className="standing-container">
      {standings}
      {display}
    </div>;
  }
}
