import * as React from 'react';

import { Tooltip, TooltipProps } from 'ui/components/tooltip';

require('./styles.scss');

interface TooltipHoverProps {
  tooltip: JSX.Element;
}

interface TooltipHoverState {
  open?: boolean;
}

export class TooltipHover extends React.Component<TooltipHoverProps, TooltipHoverState> {
  public constructor(props: any) {
    super(props);
    this.state = {
      open: false
    };
  }

  public render() {
    let { tooltip } = this.props;
    const hoverClasses = ['tooltip-hover'];
    const tooltipDisplay = this.state.open
      ? tooltip
      : undefined;

    return (
      <div
        className={hoverClasses.join(' ')}
        onMouseEnter={this.mouseEntered.bind(this)}
        onMouseLeave={this.mouseLeave.bind(this)}
      >
        {tooltipDisplay}
        {this.props.children}
      </div>
    );
  }

  private mouseEntered(event: any) {
    this.setState({
      open: true,
    });
  }

  private mouseLeave(event: any) {
    this.setState({
      open: false,
    });
  }
}
