import * as React from 'react';

require('./styles.scss');

export type TooltipPosition = 'top' | 'bottom' | 'left' | 'right' | 'top-left' | 'top-right' | 'bottom-left' | 'bottom-right';
export type TooltipType = 'error' | 'warning' | 'info';
export interface TooltipProps {
  position?: TooltipPosition;
  type?: TooltipType;
}

export class Tooltip extends React.Component<TooltipProps, void> {
  public render() {
    let { position, type } = this.props;
    const tooltipClasses = ['tooltip'];

    if (position === undefined) {
      position = 'top-left';
    }
    tooltipClasses.push(position);

    if (type === undefined) {
      type = 'error';
    }
    tooltipClasses.push(type);

    return (
      <div className={tooltipClasses.join(' ')}>
        <div className="content">{this.props.children}</div>
      </div>
    );
  }
}
