import * as React from 'react';
import { Link } from 'react-router';

import { Placeholder } from 'ui/components/placeholder';
import { Tournament } from 'common/constants';
import { AppModel } from 'state/model';
import { Button } from 'ui/components/button';

const styles = require('./styles.scss');

export class TournamentEntryComponent extends React.Component<any, any> {
  public deleteTournamentEntry() {
    return this.props.deleteTournamentEntry(this.props.tournamentEntry);
  }

  public render() {
    const { tournamentEntry } = this.props;
    let leaveButton: JSX.Element;
    if (tournamentEntry.tournament.state === 'registration_open') {
      leaveButton = <Button onClick={this.deleteTournamentEntry.bind(this)}>Leave</Button>;
    }

    return <Placeholder className="tournament-entry">
      <div className="company-icon">
        <i className="fa fa-twitch" />
      </div>
      <div className="position">
        <i className="fa fa-angle-up"/>
        1<span>st</span>
      </div>
      <div className="points">
        0<span>pts</span>
      </div>
      <div className="next-match">
        <h3>My Next Match</h3>
        <i className="fa fa-twitter" /> Twitter Firehosers
      </div>
      <div className="next-match-time">
        <i className="fa fa-clock-o" />
        May 10 @ 10PM PST
        {leaveButton}
      </div>
    </Placeholder>;
  }
}

TournamentEntryComponent.propTypes = {
  tournamentEntry: React.PropTypes.object.isRequired
};
