import * as React from 'react';
import { denormalize } from 'normalizr';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import {
  TournamentEntrySchema,
  deleteTournamentEntry
} from 'tourney-sdk-react';

import { AppModel } from 'state/model';
import { TournamentEntryComponent } from './component';

function mapStateToProps(state: AppModel, ownProps: AppModel): any {
  const tournamentEntry = denormalize(ownProps.tournamentEntry, TournamentEntrySchema, state.tourney);
  return {
    tournamentEntry
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>) {
  return bindActionCreators({
    deleteTournamentEntry
  }, dispatch);
}

export const TournamentEntry = connect(mapStateToProps, mapDispatchToProps)(TournamentEntryComponent);
