import * as React from 'react';
import { Link } from 'react-router';
import Moment from 'react-moment';
import { TournamentModel } from 'tourney-sdk-react';

import { Placeholder } from 'ui/components/placeholder';
import { Image } from 'ui/components/image';
import { urlForTournament } from 'common/helpers';
import { AppModel } from 'state/model';
import { SignupButton } from 'ui/components/signup-button';
import { TeamStandings } from 'ui/components/team/standings';

const styles = require('./styles.scss');

export interface TournamentProps {
  loading: boolean;
  tournament: TournamentModel;
  active: boolean;
  headerClick?: Function;
  showMore?: boolean;
}

export class TournamentCardComponent extends React.Component<TournamentProps, void> {
  public render() {
    const { tournament, loading, active, headerClick } = this.props;
    let classes = ['tournament-component', 'tournament-card'];

    if (loading) {
      classes.push('loading');
      return (
        <div className={classes.join(' ')}/>
      );
    }

    const boxArt = tournament.game
      ? tournament.game.cover.preview
      : undefined;

    if (active) {
      classes.push('active');
    }

    let headingProps: any = {};
    if (headerClick) {
      headingProps.onClick = headerClick;
    }

    return (
      <div className={classes.join(' ')}>
        {/*<Link to={urlForTournament(tournament)}>*/}
          <section className="heading" {...headingProps}>
            <div className="game-title">{tournament.name}</div>
            <div className="tournament-title"><Placeholder string="Season 1"/></div>
            <Image className="game-cover" src={boxArt}/>
          </section>
        {/*</Link>*/}
        <section className="entry-info">
          <div className="dates">
            <i className="fa fa-clock-o"/>
            <Moment format="MM/DD">{tournament.starts_at}</Moment> - <Moment format="MM/DD">{tournament.ends_at}</Moment>
          </div>
          <div className="entries">
            <i className="fa fa-users"/><b>{tournament.teams.length}</b>/<Placeholder string="200"/>
          </div>
          <SignupButton tournament={tournament}/>
        </section>
        <section className="standings">
          <TeamStandings
            tournament={tournament}
            showMore={false}
            showSpoilers={true}
            limit={4}
          />
        </section>
        <Link className="more-info" to={urlForTournament(tournament)}>More Info</Link>
      </div>
    );
  }
}
