import * as React from 'react';
import {
  TournamentModel,
  TeamModel,
} from 'tourney-sdk-react';

import { TeamLogo } from 'ui/components/team/logo';

const styles = require('./styles.scss');

interface ContenderProps {
  withName?: boolean;
  contender?: TeamModel;
  loading?: boolean;
}

export class Contender extends React.Component<ContenderProps, any> {
  public static defaultProps: Partial<ContenderProps> = {
    withName: true
  };

  public constructor(props: any) {
    super(props);
    // if (props.contender === undefined) {
    //   props.getTeam(props.opponent.contender_id);
    // }
  }

  public render() {
    const { withName, contender, loading } = this.props;
    const contenderClasses = ['contender'];

    if (!contender) {
      return <div className={contenderClasses.join(' ')} />;
    }

    let text;
    if (withName) {
      text = <div className="team-name">{contender.name}</div>;
    }

    return (
      <div className={contenderClasses.join(' ')}>
        <TeamLogo team={contender} />
        {text}
      </div>
    );
  }
}
