import { denormalize } from 'normalizr';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import { TeamSchema, TeamModel, updateTournamentEntry } from 'tourney-sdk-react';

import { AppModel } from 'state/model';

import { TournamentEntryRequirementsComponent } from './component';

function mapStateToProps(state: AppModel, ownProps: any): {} {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? state.tourney.users[current] : undefined;
  const team = denormalize(ownProps.entry.entrant_id, TeamSchema, state.tourney);
  const loading = team === undefined;

  return {
    user,
    team,
    loading
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>): any {
  return bindActionCreators({ updateTournamentEntry }, dispatch);
}

export const TournamentEntryRequirements = connect(mapStateToProps, mapDispatchToProps)(TournamentEntryRequirementsComponent);
