import * as React from 'react';
import * as moment from 'moment';
import { sortBy } from 'lodash';
import { TeamModel, MatchModel, OpponentModel } from 'tourney-sdk-react';

import { ICONS } from 'common/constants';
import { Image } from 'ui/components/image';
import { Contender } from 'ui/components/tournament/contender';
import { TeamLogo } from 'ui/components/team/logo';

require('./styles.scss');

export interface MatchProps {
  match: MatchModel;
  // loading: boolean;
  openReporting: any;
}

export class Match extends React.Component<MatchProps, any> {

  public render() {
    // const { match, loading, openReporting } = this.props;
    const { match, openReporting } = this.props;

    if (match.opponents === undefined) {
      return <div />;
    }
    const sortedOpponents = sortBy(match.opponents, (opp: OpponentModel) => opp.contender_id);
    const contenders = sortedOpponents.map((opponent: OpponentModel) => <Contender contender={opponent.contender} key={opponent.id}/>);

    return (
      <div className="single-match">
        <div className="teams">
          {contenders}
        </div>
        <div className="details fake-left-margin">
          <div className="game-details">
            <Image src={ICONS.game} />
            <span>{match.game.name}</span>
          </div>
          <div className="date-details">
            <Image src={ICONS.calendar} />
            <span>{moment(match.scheduled_at).format('MMM D [@] h:mm A')}</span>
          </div>
        </div>
        <div className="action action-trophy fake-left-margin" onClick={openReporting}>
          <Image src={ICONS.trophy} />
        </div>
        <div className="action action-chat fake-left-margin" onClick={openReporting}>
          <Image src={ICONS.chat} />
        </div>
      </div>
    );
  }
}
