import * as React from 'react';
import { Link } from 'react-router';
import Moment from 'react-moment';
import { TournamentModel } from 'tourney-sdk-react';

import { Placeholder } from 'ui/components/placeholder';
import { AppModel } from 'state/model';
import { SignupButton } from 'ui/components/signup-button';

const styles = require('./styles.scss');

export interface TournamentProps {
  tournament: TournamentModel;
}

export class TournamentNavComponent extends React.Component<TournamentProps, void> {
  public render() {
    const { tournament } = this.props;
    const backgroundImage: string = require('common/assets/game/lol_bg.jpg') as string;
    const boxArt: string = require('common/assets/boxart_leagueoflegends.jpg') as string;
    const style = { backgroundImage: `url(${backgroundImage})` };

    return (
      <Link className="tournament-link" to={`/tournament/${tournament.id}/`}>
        <div style={style} className="tournament-nav-component">
          <Placeholder image={boxArt} className="game-cover"/>
          <div className="title">
            {tournament.name}
          </div>
          <div className="details">
            <i className="fa fa-clock-o"/>
            <Moment format="MMM Do">{tournament.starts_at}</Moment> - <Moment format="MMM Do">{tournament.ends_at}</Moment>
            <i className="fa fa-users"/>
            <b>{tournament.teams.length}</b>/<Placeholder string="200"/>
          </div>
          <SignupButton tournament={tournament} />
        </div>
      </Link>
    );
  }
}
