import * as React from 'react';
import { denormalize } from 'normalizr';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import {
  OpponentSchema,
} from 'tourney-sdk-react';

import { AppModel } from 'state/model';
import { OpponentComponent } from './component';

function mapStateToProps(state: AppModel, ownProps: any): any {
  const opponent = denormalize(ownProps.opponentId, OpponentSchema, state.tourney);
  const loading = opponent === undefined;

  return {
    loading,
    opponent
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>) {
  return bindActionCreators({}, dispatch);
}

export const Opponent = connect(mapStateToProps, mapDispatchToProps)(OpponentComponent);
