import * as React from 'react';
import { Link } from 'react-router';

import { Placeholder } from 'ui/components/placeholder';

const styles = require('./styles.scss');

export interface ProgressSection {
  title: string;
  class: string;
  progress: number;
}

export class TournamentProgressBar extends React.Component<any, any> {
  public render(): JSX.Element {
    const tournament = this.props.tournament;
    const sections: ProgressSection[] = tournament.stages;
    const sectionsRendered: JSX.Element[] = sections.map(
      (section: ProgressSection, idx: number) : JSX.Element => this.renderSection(section, idx)
    );


    return <div className="tournament-progress">
      {sectionsRendered}
    </div>;
  }

  private renderSection(section: ProgressSection, idx: number): JSX.Element {
    const tournament = this.props.tournament;
    const containerClasses: string[] = ['progress-section'];
    if (section.progress < 1 && section.progress > 0) {
      containerClasses.push('active');
    }

    const width: number = 1 / tournament.stages.length;
    const containerStyles: Object = { width: `${width * 100}%` };

    const barClasses: string[] = ['bar-container', section.class];
    if (idx === 0) {
      barClasses.push('first');
    }
    if (idx === tournament.stages.length - 1) {
      barClasses.push('last');
    }
    const barStyles: Object = {
      width: `${100 * section.progress}%`,
      backgroundColor: section.color
    };

    return (
      <div className={containerClasses.join(' ')} style={containerStyles} key={idx}>
        <div className={barClasses.join(' ')} >
          <div className="bar-progress" style={barStyles}/>
        </div>
        <div className="progress-text">
          {section.name}
        </div>
      </div>
    );
  }
}

TournamentProgressBar.propTypes = {
  tournament: React.PropTypes.object.isRequired
};
