import * as React from 'react';
import { ICONS } from 'common/constants';
import { Image } from 'ui/components/image';

const styles = require('./styles.scss');

interface UserAvatarProps {
  avatar: string | null;
  classNames?: string[];
}

export class UserAvatar extends React.Component<UserAvatarProps, any> {
  public static defaultProps: Partial<UserAvatarProps> = {
    classNames: []
  };

  public render() {
    const { avatar, classNames } = this.props;
    const classes = ['user-avatar', ...classNames];
    const src = avatar ? avatar : require('../../../common/assets/def_avatar.png') as string;

    return <Image className={classes.join(' ')} src={src} />;
  }
}
