import 'core-js';
import 'styles/app.scss';

import * as Rollbar from '../vendor/rollbar.umd.nojson.min.js';
// See docker/nginx/run.sh on why this is here.
if (process.env.NODE_ENV !== 'development') {
  const rollbarConfig = {
    accessToken: process.env.ROLLBAR_ACCESS_TOKEN,
    captureUncaught: true,
    captureUnhandledRejections: false,
    payload: {
      environment: process.env.NODE_ENV,
      client: {
        javascript: {
          source_map_enabled: true,
          code_version: process.env.VERSION,
          guess_uncaught_frames: true
        }
      }
    }
  };
  Rollbar.init(rollbarConfig);
}

import { config } from 'config';
import * as React from 'react';
import * as ReactDOM from 'react-dom';
import { Provider } from 'react-redux';
import { browserHistory, Router, Route, Link, IndexRoute } from 'react-router';
import * as Tourney from 'tourney-sdk-react';

import { store } from 'state/store';

import { App } from './app';
import { NavigationContainer } from './components/navigation';
import { TwitchLogin } from './login';
import { CharitiesPage } from './pages/charities';
import { HomePage } from './pages/home';
import { SettingsPage } from './pages/settings';
import { SettingsOverviewSection } from './pages/settings/sections/overview';
import { SettingsMatchesSection } from './pages/settings/sections/matches';
import { TournamentDetailContainer } from './pages/tournament';
import { FAQ } from './pages/faq';
import { TournamentOverview } from './pages/tournament/sections/overview';
import { TournamentRules } from './pages/tournament/sections/rules';
import { TournamentTeams } from './pages/tournament/sections/teams';
import { TournamentIndexContainer } from './pages/tournaments';

Tourney.config.apiUrl = config.apiUrl;
Tourney.config.apiClientId = config.apiClientId;
Tourney.config.authToken = localStorage.getItem('token');
Tourney.config.store = store;

// If there's an authToken, fire off an auth request on load.
let token = localStorage.getItem('token');
if (Tourney.config.authToken) {
  store.dispatch(Tourney.authUser(Tourney.config.authToken, '', false));
}

const scrollToTop = () => window.scrollTo(0, 0);

ReactDOM.render(
  <Provider store={store}>
    <Router onUpdate={scrollToTop} history={browserHistory}>
      <Route component={App}>
        <Route path="/" component={HomePage} />
        <Route path="/auth/callback/twitch" component={TwitchLogin} />
        <Route path="/settings/verify/:email_token" component={SettingsPage} />
        <Route path="/settings/accept/:token" component={SettingsPage} />
        <Route path="/settings" component={SettingsPage} >
          <IndexRoute component={SettingsOverviewSection}/> 
          <Route path="/settings/matches" component={SettingsMatchesSection} />
        </Route>
        <Route path="/tournaments" component={TournamentIndexContainer} />
        <Route path="/tournaments/:tournament_id" component={TournamentDetailContainer}>
          <IndexRoute component={TournamentOverview}/>
          <Route path="/tournaments/:tournament_id/teams" component={TournamentTeams} />
          <Route path="/tournaments/:tournament_id/rules" component={TournamentRules} />
        </Route>
        <Route path="/charities" component={CharitiesPage} />
        <Route path="/faq" component={FAQ} />
      </Route>
    </Router>
  </Provider>,
  document.getElementById('main')
);
