import * as React from 'react';
import { TournamentModel } from 'tourney-sdk-react';

import { CHARITIES, CharityInfo } from 'common/constants';
import { Image } from 'ui/components/image';

const styles = require('./styles.scss');

export class CharitiesPage extends React.Component<any, any> {
  public render() {
    const charities = CHARITIES.map(this.renderCharity);

    return (
      <div className="charities-page">
        <div className="charities-hero">
          <h1>And it is for a good cause!</h1>
          <div className="desc">
            The After Hours Gaming League was founded for working professionals to have a fun and competitive means to play their favorite titles. More importantly however it was founded to help raise funds for charitable cause. Take a look below to learn more about the charities AHGL has partnered up with for season one!
          </div>
        </div>
        <div className="page-container">
          {charities}
        </div>
      </div>
    );
  }

  private renderCharity(charity: CharityInfo) {
    const charityStyle = { backgroundImage: `url(${charity.image})` };
    return (
      <div className="charity-container" key={charity.name}>
        <div className="charity-image-container">
          <div className="charity-img" style={charityStyle} />
        </div>
        <div className="charity-info">
          <h2>{charity.name}</h2>
          <div className="charity-desc">{charity.description}</div>
          <a href={charity.url} className="charity-website">Website</a>
        </div>
      </div>
    );
  }
}
