import * as React from 'react';
import { TournamentModel } from 'tourney-sdk-react';

import { CHARITIES, CharityInfo } from 'common/constants';
import { Image } from 'ui/components/image';

const styles = require('./styles.scss');

const content = [{
  question: 'How much is registration for one team?',
  answer: '$300 per team.',
}, {
  question: 'How long is each season?',
  answer: '8 week, 6 week regular season followed by 2 weeks of playoffs.',
}, {
  question: 'When are matches played?',
  answer: '11 am PST unless both teams have agreed to reschedule.',
}, {
  question: 'What happens if my teams forfeit a match?',
  answer: 'If this happens twice you will be removed from the league. AHGL is meant to be fun and nothing is less fun than not having an opponent to play.',
}, {
  question: 'Why isn’t my favorite game title apart of AHGL?',
  answer: 'We wanted to stay true to AHGL’s roots for the first season. We will be adding many more titles in upcoming seasons. Message us on Twitter what game titles you’d like to see added!',
}, {
  question: 'I live outside of North America, can I participate?',
  answer: 'Unfortunately play is restricted to only North American participates for season one.',
}, {
  question: 'I am an intern/part time, can I participate?',
  answer: 'As long as you have a company email address you can participate in AHGL.',
}, {
  question: 'Why do we need six people for a five person games?',
  answer: 'We have found having a substitute is crucial to  ensure companies are able to field a 5 man team everu week. Life is full of surprises and we don’t want anyone left out. ',
}, {
  question: 'Can I stream my matches?',
  answer: 'Of course! As long as you put on a 2 minute delay. We highly encourage everyone to broadcast their matches and submit Twitch clips of their favorite moments to AHGL’s Twitter.',
}, {
  question: 'What if our team can’t make our scheduled match?',
  answer: 'Please notify an admin as soon as possible. ',
}, {
  question: 'I have an issue not listed, can I speak to someone?',
  answer: 'Of course, please submit a support ticket with your issue and someone will assist you.',
}];

export class FAQ extends React.Component<any, any> {
  public render() {

    const pageContents = content.map((item: any) => {
      return (
        <div>
          <p className="question">{item.question}</p>
          <p className="answer">{item.answer}</p>
        </div>
      )
    });
    return (
      <div className="faq-page page-container">
        <h1>Frequently Asked Questions</h1>
        {pageContents}
      </div>
    );
  }
}
