import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import { denormalize } from 'normalizr';
import { TournamentModel, TournamentSchema } from 'tourney-sdk-react';

import { getActiveTournaments } from 'actions/tournaments';
import { AppModel } from 'state/model';

import { HomePageComponent } from './page';

export interface HomeStateProps {
  loading: boolean;
  activeTournamentIds: string[];
  activeTournaments: TournamentModel[];
}

function mapStateToProps(state: AppModel, ownProps: HomeStateProps): HomeStateProps {
  const activeTournamentIds = state.tournaments.active;
  const loading = activeTournamentIds === undefined || activeTournamentIds.length === 0;
  const activeTournaments = loading
    ? undefined
    : denormalize(activeTournamentIds, [TournamentSchema], state.tourney);

  return {
    loading,
    activeTournamentIds,
    activeTournaments,
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: HomeStateProps) {
  if (ownProps.activeTournamentIds === undefined || ownProps.activeTournamentIds.length === 0) {
    dispatch(getActiveTournaments());
  }

  return bindActionCreators({}, dispatch);
}

export const HomePage = connect(mapStateToProps, mapDispatchToProps)(HomePageComponent as any);
