import * as React from 'react';
import { connect } from 'react-redux';
import { denormalize, schema } from 'normalizr';
import { bindActionCreators, Dispatch } from 'redux';

import {
  verifyEmailToken,
  acceptTeamInvitation,
  UserSchema,
  authUser
} from 'tourney-sdk-react';

import { AppModel } from 'state/model';

import { SettingsPageComponent, SettingsPageProps } from './page';

function mapStateToProps(state: AppModel): any {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? denormalize(current, UserSchema, state.tourney) : undefined;

  return {
    loggedIn,
    user
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>) {
  return bindActionCreators({
    verifyEmailToken,
    acceptTeamInvitation,
    authUser,
  }, dispatch);
}

export const SettingsPage = connect(mapStateToProps, mapDispatchToProps)(SettingsPageComponent);
