import { connect } from 'react-redux';
import { keys } from 'lodash';
import { denormalize, schema } from 'normalizr';
import { bindActionCreators, Dispatch } from 'redux';
import {
  UserSchema,
  SeriesSchema,
  getMatches,
  getTeams,
} from 'tourney-sdk-react';

import { AppModel } from 'state/model';
import { getUserSeries } from 'actions/user';

import { SettingsMatchesComponent, SettingsMatchesProps } from './page';

function mapStateToProps(state: AppModel, ownProps: any): any {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? denormalize(current, UserSchema, state.tourney) : undefined;
  const mySeries = state.user.series;
  const series = denormalize(mySeries, [SeriesSchema], state.tourney);

  return {
    loggedIn,
    user,
    series,
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: any) {
  return bindActionCreators({ getUserSeries, getMatches, getTeams }, dispatch);
}

export const SettingsMatchesSection = connect(mapStateToProps, mapDispatchToProps)(SettingsMatchesComponent);
