import { connect } from 'react-redux';
import { denormalize, schema } from 'normalizr';
import { bindActionCreators, Dispatch } from 'redux';

import {
  UserSchema
} from 'tourney-sdk-react';

import { AppModel } from 'state/model';

import { SettingsOverviewComponent, SettingsOverviewProps } from './page';

function mapStateToProps(state: AppModel): any {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? denormalize(current, UserSchema, state.tourney) : undefined;

  return {
    loggedIn,
    user
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>) {
  return bindActionCreators({}, dispatch);
}

export const SettingsOverviewSection = connect(mapStateToProps, mapDispatchToProps)(SettingsOverviewComponent);
