import * as React from 'react';
import { sortBy } from 'lodash';
import { TeamModel } from 'tourney-sdk-react';

import { AppModel } from 'state/model';
import { EmailVerification } from 'ui/components/email-verification';
import { TeamCreate } from 'ui/components/team/create';
import { TeamManage } from 'ui/components/team/manage';
import { Image } from 'ui/components/image';
import { GameModal } from 'ui/components/game-modal';

const styles = require('./styles.scss');

export interface SettingsOverviewProps {
  location: any;
  loading: boolean;
  user: any;
}

export class SettingsOverviewComponent extends React.Component<any, any> {
  public constructor(...args: any[]) {
    super(...args);
    this.state = {
      gameModalOpen: false,
    };
  }

  public render() {
    let gameModal: JSX.Element = this.state.gameModalOpen
      ? <GameModal closeModal={this.closeGameModal.bind(this)} />
      : undefined;
    return (
      <div className="">
        <div className="page-container">
          {this.renderTeams()}
        </div>
        {gameModal}
      </div>
    );
  }

  public renderTeams(): JSX.Element {
    const manageTeams: JSX.Element[] = sortBy(this.props.user.teams, 'name').map(
      (team: TeamModel, idx: number) => <TeamManage team={team} key={idx} openGameModal={this.openGameModal.bind(this)}/>);

    return <div className="teams-sub-page">
      <h2>My Teams</h2>
      {manageTeams}
      <TeamCreate />
    </div>;
  }

  private openGameModal() {
    this.setState({
      gameModalOpen: true
    });
  }

  private closeGameModal() {
    this.setState({
      gameModalOpen: false
    });
  }
}
