import * as React from 'react';
import { denormalize } from 'normalizr';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import {
  UserSchema,
  TournamentSchema,
  createTournamentEntry,
  getTournament,
  createTeam,
  deleteTournamentEntry,
} from 'tourney-sdk-react';

import { AppModel } from 'state/model';

import { TournamentDetail } from './page';

function mapStateToProps(state: AppModel, ownProps: AppModel): any {
  const current = state.tourney.users.current;
  const loggedIn = current !== undefined;
  const user = loggedIn ? denormalize(current, UserSchema, state.tourney) : undefined;
  const tournamentId = ownProps.routeParams.tournament_id;
  const tournament = denormalize(tournamentId, TournamentSchema, state.tourney);
  const loading = tournament === undefined;

  return {
    tournamentId,
    loggedIn,
    user,
    tournament,
    loading
  };
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: AppModel) {

  return bindActionCreators({
    createTournamentEntry,
    createTeam,
    deleteTournamentEntry,
    getTournament,
  }, dispatch);
}

export const TournamentDetailContainer = connect(mapStateToProps, mapDispatchToProps)(TournamentDetail);
