import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import { createTournamentEntry, createTeam } from 'tourney-sdk-react';

import { AppModel } from 'state/model';

import { TournamentOverviewComponent } from './page';

function mapStateToProps(state: AppModel, ownProps: AppModel): AppModel {
  return state;
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>) {
  return bindActionCreators({ createTournamentEntry, createTeam }, dispatch);
}

export const TournamentOverview = connect(mapStateToProps, mapDispatchToProps)(TournamentOverviewComponent);
