import * as React from 'react';
import { Link } from 'react-router';

import { Placeholder } from 'ui/components/placeholder';
import { TEMP_NEWS, NewsArticle } from 'common/constants';
import { AppModel } from 'state/model';
import { NewsPreview } from 'ui/components/news/preview';
import { TeamSelect } from 'ui/components/team-select';
import { TeamLogoList } from 'ui/components/team/logo-list';
import { TeamStandings } from 'ui/components/team/standings';
import { TournamentEntry } from 'ui/components/tournament-entry';

const styles = require('./styles.scss');

export class TournamentOverviewComponent extends React.Component<any, any> {
  public render() {
    const { tournament } = this.props;
    return (
      <div className="overview-container">
        <section className="overview-updates">
          <div className="section-title">Activity Feed</div>
          <div className="activity-container"/>
        </section>
        <section className="overview-standing">
          <div className="section-title">Standings</div>
          <TeamStandings
            tournament={tournament}
            showSpoilers={true}
            showMore={true}
          />
        </section>
      </div>
    );
  }
}
