import * as _ from 'lodash';
import * as React from 'react';
import { TeamModel } from 'tourney-sdk-react';

import { Placeholder } from 'ui/components/placeholder';
import { AppModel } from 'state/model';
import { TeamSelect } from 'ui/components/team-select';
import { TeamButton } from 'ui/components/team/button';
import { TournamentEntry } from 'ui/components/tournament-entry';

const styles = require('./styles.scss');

export class TournamentTeamsComponent extends React.Component<any, any> {
  public render() {
    const tournament = this.props.tournament;
    const allTeams = tournament.teams
      .map((team: TeamModel, idx: number) => <TeamButton team={team} key={idx}/>);

    return (
      <div className="teams-container">
        <div className="teams-heading">
          <div className="team-count"><b>{tournament.teams.length}</b> Teams</div>
        </div>
        <div className="all-teams">
          {allTeams}
        </div>
      </div>
    );
  }
}
