import * as React from 'react';
import { connect } from 'react-redux';
import { bindActionCreators, Dispatch } from 'redux';
import { TournamentModel } from 'tourney-sdk-react';

import { getActiveTournaments } from 'actions/tournaments';
import { AppModel } from 'state/model';

import { TournamentIndex } from './page';

export interface TournamentsIndexStateProps {
  loading: boolean;
  activeTournaments: string[];
  tournamentsById: any;
}

function mapStateToProps(state: AppModel): TournamentsIndexStateProps {
  return {
    loading: state.tournaments.active && state.tournaments.active.length > 0 ? false : true,
    activeTournaments: state.tournaments.active,
    tournamentsById: state.tourney.tournaments
  };
}

export interface TournamentsIndexDispatchProps {
  getActiveTournaments: Function;
}

function mapDispatchToProps(dispatch: Dispatch<AppModel>, ownProps: TournamentsIndexStateProps) {
  // check if we need to load active tournaments
  if (!ownProps.activeTournaments) {
    dispatch(getActiveTournaments());
  }

  return bindActionCreators({ getActiveTournaments }, dispatch);
}

export const TournamentIndexContainer = connect(mapStateToProps, mapDispatchToProps)(TournamentIndex as any);
