import * as React from 'react';
import { TournamentModel } from 'tourney-sdk-react';

import { Placeholder } from 'ui/components/placeholder';
import { Tournament } from 'common/constants';
import { AppModel } from 'state/model';
import { TournamentNav } from 'ui/components/tournament/nav';

import { TournamentsIndexStateProps, TournamentsIndexDispatchProps } from './index';

interface TournamentsIndexState {
  loading: Boolean;
}

const styles = require('./styles.scss');

type AllProps = TournamentsIndexStateProps & TournamentsIndexDispatchProps;
export class TournamentIndex extends React.Component<AllProps, TournamentsIndexState> {
  public render() {
    if (this.props.loading) {
      return <div className="loading">
        Loading
      </div>;
    }

    const selectableTournaments: TournamentModel[] = this.props.activeTournaments.map((id: string) => this.props.tournamentsById[id]);
    const renderedTournaments: JSX.Element[] = selectableTournaments.map((tournament: TournamentModel): JSX.Element => {
      return (
        <TournamentNav key={tournament.id} tournament={tournament}/>
      );
    });

    return (
      <div className="page-container tournaments-container">
        {renderedTournaments}
      </div>
    );
  }
}
