#!/bin/bash

name=tourney-fig
region=us-west-2
ecr_staging=157383839067.dkr.ecr.us-west-2.amazonaws.com/tourney-fig
branch=`git rev-parse --abbrev-ref @`
version=`git rev-parse --short HEAD`
branch=HEAD

function ensure {
    "$@"
    local status=$?
    if [ $status -ne 0 ]; then
        echo "error with $1" >&2
        exit 1
    fi
    return $status
}

read -p "Build app? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  export NODE_ENV=production
  export VERSION=$version
  export ROLLBAR_SERVER_ACCESS_TOKEN=722478042df44513a3c9d6afa50e43b4
  export ROLLBAR_ACCESS_TOKEN=ef03a8b39e574a0b8eda14cbdea71ec6
  export API_CLIENT_ID=tOqcB53jsx0
  export API_URL=http://tourney-edge.staging.esports.internal.justin.tv
  export TWITCH_CALLBACK_URL=http://tourney-fig.staging.esports.internal.justin.tv/auth/callback/twitch
  ensure docker run \
    -v `pwd`:/app \
    -e NODE_ENV \
    -e VERSION \
    -e ROLLBAR_SERVER_ACCESS_TOKEN \
    -e ROLLBAR_ACCESS_TOKEN \
    -e API_CLIENT_ID \
    -e API_URL \
    -e TWITCH_CALLBACK_URL \
    node:7.7 /bin/sh -c "cd /app && yarn install && npm install node-sass && yarn build"
  ensure docker build -t ${name}:latest -f docker/Dockerfile .
  ensure docker tag ${name}:latest ${ecr_staging}:latest
fi

read -p "Push docker image? [Y/N]" -r
echo
if [[ $REPLY =~ ^[Yy]$ ]]; then
  case "$1" in
    production)
      echo "We don't take too kindly to production in these parts."
      ;;
    staging)
      `aws ecr get-login --region ${region} --profile twitch-esports-dev`
      if [ $? -ne 0 ]; then `aws ecr get-login --region ${region}`; fi
      ensure docker push ${ecr_staging}:latest
      ;;
  esac
fi

