import * as React from 'react';
import { shallow, mount, render } from 'enzyme';

import { Button } from 'ui/components/button';

const onClick = jest.fn(() => Promise.resolve({}));

describe('TeamSelect', () => {
  beforeEach(() => {
    jest.clearAllMocks();
  });

  describe('component render', () => {
    it('should render button class', () => {
      const component = shallow(<Button />);

      expect(component.find('button').exists()).toBe(true);
    });

    it('should render valid sizes', () => {
      const props = {
        size: Button.SIZES.small
      };
      const component = shallow(<Button {...props} />);

      expect(component.find('button').hasClass('size-small')).toBe(true);
    });

    it('should render loading', () => {
      const props = {
        loading: true
      };
      const component = shallow(<Button {...props} />);

      expect(component.find('button').hasClass('loading')).toBe(true);
    });

    it('should render error', () => {
      const props = {
        error: true
      };
      const component = shallow(<Button {...props} />);

      expect(component.find('button').hasClass('error')).toBe(true);
    });

    it('should render skip loading if set to false', () => {
      const props = {
        loading: false
      };
      const component = shallow(<Button {...props} />);

      expect(component.find('button').hasClass('loading')).toBe(false);
    });

    it('should render primary', () => {
      const component = shallow(<Button primary/>);

      expect(component.find('button').hasClass('primary')).toBe(true);
    });

    it('should render secondary', () => {
      const component = shallow(<Button secondary/>);

      expect(component.find('button').hasClass('secondary')).toBe(true);
    });

    it('should render twoLine', () => {
      const component = shallow(<Button twoLine/>);

      expect(component.find('button').hasClass('two-line')).toBe(true);
    });

    it('should render hidden', () => {
      const component = shallow(<Button hidden/>);

      expect(component.find('button').hasClass('hidden')).toBe(true);
    });

    it('should render connect', () => {
      const props = {
        connect: Button.CONNECTS.left
      };
      const component = shallow(<Button {...props}/>);

      expect(component.find('button').hasClass('connect-left')).toBe(true);
    });
  });

  describe('component actions', () => {
    it('should allow onclick', () => {
      const props = {
        onClick,
      };

      const component = shallow(<Button {...props} />);
      component.find('button').simulate('click');
      expect(onClick).toBeCalled();
    });
  });
});
