import * as React from 'react';
import { shallow, mount, render, ReactWrapper } from 'enzyme';
import { UserModel } from 'tourney-sdk-react';

import { TeamCreateComponent } from 'ui/components/team/create/component';

import { TEST_TEAM } from '../../constants';

const testUser: any = TEST_TEAM.users[0];

const mockCreateTeam = jest.fn((teamName: string) => {
  return Promise.resolve({});
});
const props = {
  loggedIn: true,
  user: testUser,
  createTeam: mockCreateTeam
};

describe('TeamCreate', () => {
  let component: ReactWrapper<any, any>;
  let testName = 'testTeam';
  const charity = 'Extra Life';
  beforeEach(() => {
    component = mount(
      <TeamCreateComponent {...props}/>
    );
    mockCreateTeam.mockClear();
  });

  describe('component renderings', () => {
    it('should start by rendering create team', () => {
      expect(component.find('.create-text').exists()).toBe(true);
      expect(component.find('.create-name').exists()).toBe(false);
    });

    it('should switch to create team to input team name', () => {
      component.find('.create-team').simulate('click');
      expect(component.find('.create-text').exists()).toBe(false);
      expect(component.find('.create-team-name').exists()).toBe(true);
    });
  });

  describe('creating team actions', () => {
    it('should call create team when not empty', () => {
      component.find('.create-team').simulate('click');
      expect(component.find('.create-text').exists()).toBe(false);
      component.find('.create-team-name').simulate('change', { target: { value: testName } });
      component.find('.create-team-charity').simulate('change', { target: { value: charity } });
      expect(component.find('.create-team-name').props().value).toEqual(testName);
      expect(component.find('.create-team-charity').props().value).toEqual(charity);
      component.find('.button').simulate('click');
      expect(mockCreateTeam).toBeCalledWith({
        name: testName,
        settings: {
          charity
        }
      });
    });

    it('should not call create team if team name and charity are empty', () => {
      component.find('.create-team').simulate('click');
      expect(component.find('.create-text').exists()).toBe(false);
      component.find('.button').simulate('click');
      expect(mockCreateTeam).not.toBeCalled();
    });

    it('should not call create team if charity is empty', () => {
      component.find('.create-team').simulate('click');
      expect(component.find('.create-text').exists()).toBe(false);
      component.find('.create-team-name').simulate('change', { target: { value: testName } });
      component.find('.button').simulate('click');
      expect(mockCreateTeam).not.toBeCalled();
      expect(component.find('.tooltip').hasClass('error')).toBe(true);
    });

    it('should not call create team if only team name is empty', () => {
      component.find('.create-team').simulate('click');
      expect(component.find('.create-text').exists()).toBe(false);
      component.find('.create-team-charity').simulate('change', { target: { value: charity } });
      expect(component.find('.create-team-charity').props().value).toEqual(charity);
      component.find('.button').simulate('click');
      expect(mockCreateTeam).not.toBeCalled();
    });

  });
});
