import * as React from 'react';
import { shallow, mount, render, ShallowWrapper, ReactWrapper } from 'enzyme';
import { UserModel } from 'tourney-sdk-react';

import { TeamInviteComponent } from 'ui/components/team/invite/component';
import { TEST_TEAM, TEST_TEAM_INVITATION } from '../../constants';

const createTeamInvitation = jest.fn(() => Promise.resolve({}));
const createTeamInvitationError = jest.fn(() => Promise.reject({}));

const props = {
  teamId: TEST_TEAM.id,
  createTeamInvitation
};
const testEmail = 'test@example.com';

describe('TeamInvite', () => {
  describe('Rendering', () => {
    let component: ReactWrapper<any, any>;
    beforeEach(() => {
      component = mount(
        <TeamInviteComponent {...props}/>
      );
      jest.clearAllMocks();
    });

    it('should initially not be an error', () => {
      expect(component.find('button').hasClass('error')).toBe(false);
      expect(component.find('button').hasClass('loading')).toBe(false);
    });

    it('should allow email change', () => {
      let localProps = {
        ...props,
        createTeamInvitation: createTeamInvitationError
      };
      component.find('input').simulate('change', { target: { value: testEmail } });
      expect(component.find('input').props().value).toEqual(testEmail);
      component.find('button').simulate('click');
      expect(createTeamInvitation).toBeCalled();
      expect(component.find('button').hasClass('loading')).toBe(true);
    });

    it('should allow email change error', () => {
      let localProps = {
        ...props,
        createTeamInvitation: createTeamInvitationError
      };
      let comp = mount(
        <TeamInviteComponent {...localProps}/>
      );
      comp.find('input').simulate('change', { target: { value: testEmail } });
      expect(comp.find('input').props().value).toEqual(testEmail);
      comp.find('button').simulate('click');
      expect(createTeamInvitationError).toBeCalled();
      expect(comp.find('button').hasClass('loading')).toBe(true);
    });
  });
});
