import * as React from 'react';
import { shallow, mount, render } from 'enzyme';
import { TeamModel } from 'tourney-sdk-react';

import { TeamLogoListComponent } from 'ui/components/team/logo-list/component';

import { TEST_TOURNAMENT } from '../../constants';

const props = {
  tournament: TEST_TOURNAMENT,
  limit: 6,
};

describe('LogoList', () => {
  describe('component render', () => {
    it('should render all logos when under limit', () => {
      const component = mount(
        <TeamLogoListComponent {...props} />
      );
      expect(component.find('.team-logo').length).toBe(TEST_TOURNAMENT.teams.length);
      expect(component.find('.all-teams-link').exists()).toBe(false);
    });

    it("should render partial logos and 'show more' when under limit", () => {
      const limit = 1;
      const localProps = {
        ...props,
        limit,
      };
      const component = mount(
        <TeamLogoListComponent {...localProps} />
      );
      expect(component.find('.team-logo').length).toBe(limit);
      expect(component.find('.all-teams-link').exists()).toBe(true);
      expect(component.find('.all-teams-link').text()).toContain(TEST_TOURNAMENT.teams.length - limit);
    });
  });
});
