import * as React from 'react';
import { shallow, mount, render, ShallowWrapper, ReactWrapper } from 'enzyme';
import { UserModel } from 'tourney-sdk-react';

import { TeamManageComponent } from 'ui/components/team/manage/component';
import { TEST_TEAM, TEST_TEAM_INVITATION, TEST_USER } from '../../constants';

const deleteTeamUser = jest.fn(() => Promise.resolve({}));
const deleteTeamInvitation = jest.fn(() => Promise.resolve({}));
const getTeam = jest.fn(() => Promise.resolve({}));

const props = {
  team: TEST_TEAM,
  deleteTeamUser,
  deleteTeamInvitation,
  getTeam,
  myUser: TEST_TEAM.users[0]
};

describe('TeamManage', () => {
  describe('rendering', () => {
    let component: ReactWrapper<any, any>;
    let testName = 'testTeam';
    beforeEach(() => {
      component = mount(
        <TeamManageComponent {...props}/>
      );
      jest.clearAllMocks();
    });

    it('should render players', () => {
      expect(component.find('.single-player.player').length).toEqual(TEST_TEAM.users.length);
      expect(component.find('.single-player.player').first().exists()).toBe(true);
    });

    it('should render invitiations', () => {
      expect(component.find('.single-player.invitation').length).toEqual(TEST_TEAM.team_invitations.length);
    });

    it('should render invitiations', () => {
      let localProps = {
        ...props,
        team: {
          ...props.team,
          team_invitations: [
            TEST_TEAM_INVITATION
          ]
        }
      };
      let comp = shallow(
        <TeamManageComponent {...localProps}/>
      );
      expect(comp.find('.single-player.invitation').length).toEqual(1);
    });
  });

  describe('Actions', () => {
    let component: ShallowWrapper<any, any>;
    beforeEach(() => {
      component = shallow(
        <TeamManageComponent {...props}/>
      );
      jest.clearAllMocks();
    });

    it('should respond to share state change', () => {
      expect(component.find('.add-player').exists()).toBe(true);
      component.find('.add-player').simulate('click');
      expect(component.find('.add-player').exists()).toBe(false);
      expect(component.find('.share-link').exists()).toBe(true);
    });
  });
});
