import * as React from 'react';
import { shallow, mount, render } from 'enzyme';
import { TeamModel } from 'tourney-sdk-react';

import { TeamStandingComponent } from 'ui/components/team/standing/component';

import { TEST_TEAM } from '../../constants';

const props = {
  team: TEST_TEAM,
  showSpoilers: true
};
describe('TeamStanding', () => {
  describe('component render', () => {
    it('should render a single team standing', () => {
      const component = mount(
        <TeamStandingComponent {...props}/>
      );
      expect(component.find('.team-standing').exists()).toBe(true);
    });

    it('should support hiding spoilers', () => {
      const localProps = {
        ...props,
        showSpoilers: false
      };

      const component = mount(
        <TeamStandingComponent {...localProps}/>
      );
      expect(component.find('.team-standing').exists()).toBe(true);
      expect(component.find('.team-standing.hide-spoilers').exists()).toBe(true);
    });
  });
});
