import * as React from 'react';
import { shallow, mount, render } from 'enzyme';
import { TeamModel } from 'tourney-sdk-react';

import { TeamStandingsComponent } from 'ui/components/team/standings/component';

import { TEST_TOURNAMENT } from '../../constants';

const props = {
  tournament: TEST_TOURNAMENT,
  limit: 5,
};

describe('TeamStandings', () => {
  describe('component render', () => {
    it('should render team all standings when under limit', () => {
      const component = mount(
        <TeamStandingsComponent {...props}/>
      );
      expect(component.find('.standing-container').exists()).toBe(true);
      expect(component.find('.team-standing').length).toBe(TEST_TOURNAMENT.teams.length);
    });

    it('should render only limit amount along with information on additonal teams', () => {
      const limit = 1;
      const localProps = {
        ...props,
        limit,
        showMore: true
      };
      const component = mount(
        <TeamStandingsComponent {...localProps}/>
      );
      expect(component.find('.standing-container').exists()).toBe(true);
      expect(component.find('.team-standing').length).toBe(limit);
      expect(component.find('.more-teams').exists()).toBe(true);
      expect(component.find('.more-teams').text()).toContain(TEST_TOURNAMENT.teams.length - limit);
    });
  });
});
