import * as React from 'react';
import { shallow, mount, render } from 'enzyme';

import { Tooltip } from 'ui/components/tooltip';

describe('Tooltip', () => {

  describe('component render', () => {
    it('should render with defaults', () => {
      const component = shallow(<Tooltip />);

      expect(component.find('.tooltip').exists()).toBe(true);
      expect(component.find('.tooltip').hasClass('top-left')).toBe(true);
      expect(component.find('.tooltip').hasClass('error')).toBe(true);
    });

    it('should render with non-default position', () => {
      const component = shallow(<Tooltip position="top-right" />);

      expect(component.find('.tooltip').hasClass('top-right')).toBe(true);
    });

    it('should render with non-default type', () => {
      const component = shallow(<Tooltip type="warning" />);

      expect(component.find('.tooltip').hasClass('warning')).toBe(true);
    });

    it('should render text inside content container', () => {
      const testString = 'This is a test String';
      const component = shallow(<Tooltip>{testString}</Tooltip>);

      expect(component.find('.content').text()).toEqual(testString);
    });
  });
});
