import * as React from 'react';
import { shallow, mount, render } from 'enzyme';
import { TournamentModel } from 'tourney-sdk-react';

import { TournamentEntryRequirementsComponent } from 'ui/components/tournament/entry-requirements/component';

import { TEST_ENTRY, TEST_TEAM } from '../../constants';

const baseRequirements = {
  playerCount: 5
};

const baseProps = {
  entry: TEST_ENTRY,
  requirements: baseRequirements,
  team: TEST_ENTRY.entrant,
  loading: false
};

describe('Tournament Entry Requirements', () => {
  describe('component renders', () => {
    it('should render when suplied entry and requirements', () => {
      const component = shallow(
        <TournamentEntryRequirementsComponent {...baseProps}/>
      );
      expect(component.find('.tournament-requirements').exists()).toBe(true);
    });
  });

  describe('component reacts to requirements', () => {
    it('should show the error without enough verified players', () => {
      const component = shallow(
        <TournamentEntryRequirementsComponent {...baseProps}/>
      );
      expect(component.find('.players .req-content').text()).toEqual('1/5');
      expect(component.find('.players .req-content').hasClass('error')).toBe(true);
      expect(component.find('.message').hasClass('error')).toBe(true);
    });

    it('should show the success for payment_recieved when flag is present', () => {
      const component = shallow(
        <TournamentEntryRequirementsComponent {...baseProps}/>
      );
      expect(component.find('.payment .req-content').text()).toEqual('Paid');
      expect(component.find('.payment .req-content').hasClass('success')).toBe(true);
    });

    it('should be successful with all requirements met', () => {
      const localProps = {
        ...baseProps,
        requirements: {
          playerCount: 1
        },
      };

      const component = shallow(
        <TournamentEntryRequirementsComponent {...localProps}/>
      );
      expect(component.find('.players .req-content').text()).toEqual('1/1');
      expect(component.find('.players .req-content').hasClass('success')).toBe(true);
      expect(component.find('.payment .req-content').text()).toEqual('Paid');
      expect(component.find('.payment .req-content').hasClass('success')).toBe(true);
      expect(component.find('.message').hasClass('success')).toBe(true);
    }); 
  });
});
