import * as React from 'react';
import { shallow, mount, render } from 'enzyme';
import { TeamModel } from 'tourney-sdk-react';

import { TournamentDetail } from 'ui/pages/tournament/page';

import { TEST_TOURNAMENT, TEST_TEAM } from '../constants';

const createTournamentEntry = jest.fn(() => Promise.resolve({}));
const createTeam = jest.fn(() => Promise.resolve({}));

// mock browser location.pathname from react router
const location = {
  pathname: '/tournament/5b6e194b-20b5-4294-a9d2-16cf774daa79/',
};
let user: any;

const props = {
  loggedIn: false,
  user,
  tournament: TEST_TOURNAMENT,
  loading: false,
  createTournamentEntry,
  createTeam,
  location,
};

describe('TournamentDetail', () => {
  beforeEach(() => {
    jest.clearAllMocks();
  });

  describe('component render without user login', () => {
    it('should render without any teams/register options', () => {
      const component = shallow(
        <TournamentDetail {...props} />
      );
      expect(component.find('.tournament-page').exists()).toBe(true);
    });
  });
});
