'use strict';

const path = require('path');
const process = require('process');
const webpack = require('webpack');
const RollbarSourceMapPlugin = require('rollbar-sourcemap-webpack-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');
let basePath = __dirname;
const baseUrl = '//tourney-fig.staging.esports.internal.justin.tv';

module.exports = {
  name: 'fig',
  entry: './app/ui/index.tsx',
  target: 'web', // default
  devServer: {
    inline: true,
    hot: true,
    port: 5200
  },
  plugins: [
    new RollbarSourceMapPlugin({
      accessToken: process.env.ROLLBAR_SERVER_ACCESS_TOKEN,
      version: process.env.VERSION,
      publicPath: baseUrl
    }),
    new HtmlWebpackPlugin({
      title: 'Fig',
      template: 'index.ejs'
    }),
    new webpack.HotModuleReplacementPlugin(),
    new webpack.EnvironmentPlugin({
      NODE_ENV: 'development',
      API_URL: undefined,
      API_CLIENT_ID: undefined,
      TWITCH_CALLBACK_URL: false,
      VERSION: false,
      ROLLBAR_ACCESS_TOKEN: false
    })
  ],
  output: {
    path: path.join(process.cwd(), '/dist/'),
    publicPath: '/',
    filename: 'bundle-[hash].js'
  },
  resolve: {
    alias: {
      config: path.join(__dirname, 'config', process.env.NODE_ENV || 'development')
    },
    extensions: ['.js', '.jsx', '.ts', '.tsx'],
    modules: [
      path.join(__dirname, 'app'),
      path.join(__dirname, 'node_modules')
    ]
  },
  module: {
    rules: [
      {
        test: /\.ts?$/,
        loader: 'tslint-loader',
        enforce: 'pre',
        exclude: [/node_modules/, /dist/, /vendor/],
      },
      {
        test: /\.tsx?$/,
        loader: 'ts-loader',
        exclude: [/node_modules/, /dist/, /vendor/],
        query: {
          // Most of these are related to having multiple TS definitions
          // deep within node_modules when symlinking libs/etc.
          ignoreDiagnostics: [
            2403,
            2324, // Poperty missing in compound type.. wasn't there a TS issue about this?
            2687, // All declarations of ... must have identifcal
            2300, // Duplicate identifier..
            2339, // connected components IntrinsicAttributes
            2428, // WeakMap redefined in @lodash/types
            7016  // No definitions for react-moment :(
          ]
        }
      },
      {
        enforce: 'pre',
        test: /\.js$/,
        loader: "source-map-loader"
      },
      {
        enforce: 'pre',
        test: /\.tsx?$/,
        use: "source-map-loader"
      },
      {
        test: /\.scss$/,
        use: [
          'style-loader',
          'css-loader',
          {
            loader: 'sass-loader',
            options: {
              includePaths: [path.resolve(__dirname, "./app/styles")]
            }
          }
        ]
      },
      {
        test: /\.(gif|jpg|png|svg)$/,
        loader: 'file-loader'
      }
    ]
  },
   devtool: process.env.NODE_ENV === 'development' ? 'inline-source-map' : 'source-map',
};
