class ApplicationController < ActionController::Base
  # Prevent CSRF attacks by raising an exception.
  # For APIs, you may want to use :null_session instead.
  protect_from_forgery with: :null_session

  def health
    render plain: ''
  end

  # Lograge
  def append_info_to_payload(payload)
    # Include internal headers in logs
    log_headers = ['X-Roles', 'Client-ID', 'User-ID']
    payload[:headers] = Hash[*log_headers.collect{|h| [h, request.headers[h]]}.flatten]
  end
end
