class OmniauthCallbacksController < V1::BaseController
  include Authorization
  require_client! only: [:setup]

  # Omniauth suppresses all output from the call to this. If an auth request
  # returns empty and the log only sports `Calling through to underlying
  # application for setup.`, this is likely the culprit.
  def setup
    request.env['omniauth.strategy'].options.merge!(
      client_id: client.twitch_client_id,
      client_secret: client.twitch_client_secret,
      redirect_uri: client.redirect_url,
      provider_ignores_state: true, # disable CSRF protection, we're an internal API.
      authorize_options: [:state],
      state: token.token
    )
  end

  def callback
    if auth.nil? || auth.uid.blank?
      render plain: '', status: 400 and return
    end

    @account = Account.find_by(provider: provider, uid: auth.uid)
    @user = @account&.user ||
            Account.find_by(email: auth.info.email)&.user ||
            (!auth.info.email.blank? && User.find_by(email: auth.info.email)) ||
            User.create!

    if @account.nil?
      @account = Account.create!(
        provider: provider,
        uid: auth.uid,
        email: auth.info.email,
        data: auth,
        user: @user
      )
    else
      @account.update!(user: @user)
    end

    token.update_attribute(:user_id, @account.user_id)
    render json: @account.user, serializer: V1::UserPresenter
  end

  private

  def auth
    @auth ||= Hashie::Mash.new request.env['omniauth.auth']
  end

  def token
    @token ||= begin
      params[:token] ||= params[:state] || SecureRandom.hex(64)
      Token.where(token: params[:token]).first_or_create!
    end
  end

  def provider
    params.require(:provider)
  end
end
